package com.biz.crm.sfa.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 考勤规则多条件dto
 *
 * @author ning.zhang
 * @date 2022/5/6
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RuleConditionDto", description = "考勤规则多条件dto")
public class RuleConditionDto {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /***
   * 企业组织编码集合
   */
  @ApiModelProperty("企业组织编码集合")
  private List<String> orgCodes;

  /***
   * 考勤规则编码集合
   */
  @ApiModelProperty("考勤规则编码集合")
  private List<String> ruleCodes;


  /***
   * 启禁用状态
   *
   * @see com.biz.crm.business.common.sdk.enums.EnableStatusEnum
   */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /***
   * 排除考勤规则ID集合
   */
  @ApiModelProperty("排除考勤规则ID集合")
  private List<String> excludeIds;
}
