package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 考勤规则非工作遵守数据dto
 *
 * @author ning.zhang
 * @date 2022/6/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RuleNoWorkAbideDataDto", description = "考勤规则非工作遵守数据dto")
public class RuleNoWorkAbideDataDto extends TenantDto {

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private Set<String> ruleCodes;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 考勤日期
   */
  @ApiModelProperty("考勤日期")
  private String ruleDate;
}
