package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 今日考勤历史记录Dto
 *
 * @author ning.zhang
 * @date 2022/5/20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TodayHistoryRecordDto", description = "今日考勤历史记录Dto")
public class TodayHistoryRecordDto extends TenantDto {

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty(value = "打卡类型(on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 截止考勤记录ID(查询此ID之前的数据,不包含自身)
   */
  @ApiModelProperty(value = "截止考勤记录ID(查询此ID之前的数据,不包含自身)")
  private String beforeRecordId;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号", hidden = true)
  private String userName;


  @ApiModelProperty("人员账号集合")
  private Set<String> userNames;
}
