package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤打卡时间状态枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceClockTimeStatus {

  /**
   * 当前可打卡
   */
  CURRENT_CAN_CLOCK("current_can_clock", "current_can_clock", "当前可打卡", "1"),
  /**
   * 未到打卡时间
   */
  NOT_CLOCK_TIME("not_clock_time", "not_clock_time", "未到打卡时间", "2"),
  /**
   * 今日无需打卡
   */
  TODAY_NOT_NEED_CLOCK("today_not_need_clock", "today_not_need_clock", "今日无需打卡", "3"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
