package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤下班打卡类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceOffWorkClockType {

  /**
   * 下班不需要打卡
   */
  NO_SIGN("no_sign", "no_sign", "下班不需要打卡", "1"),
  /**
   * 下班需要打卡，且必须打上班卡才能打下班卡
   */
  GOTO_WORK_REQUIRED("goto_work_required", "goto_work_required", "下班需要打卡，且必须打上班卡才能打下班卡", "2"),
  /**
   * 下班需要打卡，无需打上班卡，就能打下班卡
   */
  GOTO_WORK_NO_REQUIRED("goto_work_no_required", "goto_work_no_required", "下班需要打卡，无需打上班卡，就能打下班卡", "3"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
