package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤规则生效类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceRuleEffectiveType {

  /**
   * 马上生效
   */
  NOW("now", "now", "马上生效", "1"),
  /**
   * 明日生效
   */
  TOMORROW("tomorrow", "tomorrow", "明日生效", "2"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
