package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤规则范围类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceRuleScopeType {

  /**
   * 组织
   */
  ORG("org", "org", "组织", "1"),
  /**
   * 职位级别
   */
  POSITION_LEVEL("position_level", "position_level", "职位级别", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
