package com.biz.crm.sfa.business.attendance.sdk.event;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import org.springframework.data.domain.Pageable;

/**
 * 考勤上层数据获取监听器
 * 本服务无法实现的数据关联查询,可以通过该接口向上层发送数据请求来实现数据的封装
 *
 * @author ning.zhang
 * @date 2022/9/2
 */
public interface AttendanceUpperDataListener {

  /**
   * 补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto);

}
