package com.biz.crm.sfa.business.attendance.sdk.service;

import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;

import java.util.List;
import java.util.Set;

/**
 * 考勤规则Vo表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-05 09:43:07
 */
public interface AttendanceRuleVoService {

  /**
   * 通过考勤规则ID获取考勤规则信息
   *
   * @param id 考勤规则ID
   * @return 考勤规则信息
   */
  AttendanceRuleVo findById(String id);

  /**
   * 通过考勤规则查询条件获取考勤规则信息
   *
   * @param dto 参数dto
   * @return 考勤规则信息
   */
  List<AttendanceRuleVo> findByRuleConditionDto(RuleConditionDto dto);
}
