package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 考勤补打卡申请信息Vo
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceFillApplyVo", description = "考勤补打卡申请信息Vo")
public class AttendanceFillApplyVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -2486797632183312559L;
  /**
   * 申请原因
   */
  @ApiModelProperty("申请原因")
  private String applyReason;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  private String applyCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员名称
   */
  @ApiModelProperty("人员名称")
  private String userRealName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 补打卡考勤记录信息
   */
  @ApiModelProperty("补打卡考勤记录信息")
  private List<AttendanceRecordVo> recordList;

  /**
   * 补打卡图片信息
   */
  @ApiModelProperty("补打卡图片信息")
  private List<FileVo> pictureList;

  /**
   * 异常打卡记录集合
   */
  @ApiModelProperty("异常打卡记录集合")
  private String recordIds;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 打卡类型
   */
  @ApiModelProperty("打卡类型")
  private String clockType;

  /**
   * 工作流程信息
   */
  @ApiModelProperty("工作流程信息")
  private ProcessBusinessVo processBusiness;
}
