package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 考勤记录Vo
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRecordVo", description = "考勤记录Vo")
public class AttendanceRecordVo extends UuidFlagOpVo {

  private static final long serialVersionUID = 3162461515726434038L;

  /**
   * 考勤记录规则ID
   */
  @ApiModelProperty("考勤记录规则ID")
  private String ruleRecordId;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  private String ruleCode;

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 是否已经使用(Y:已经打卡;N:未处理)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否已经使用(Y:已经打卡;N:未处理)")
  private String usedStatus;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  private String ruleDate;

  /**
   * 打卡时间(HH:mm:ss)
   */
  @ApiModelProperty("打卡时间(HH:mm:ss)")
  private String clockTime;

  /**
   * 考勤时间规则ID
   */
  @ApiModelProperty("考勤规则时间ID")
  private String ruleTimeId;

  /**
   * 考勤时间规则-打卡时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡时间(HH:mm:ss)")
  private String ruleClockTime;

  /**
   * 考勤时间规则-打卡开始时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡开始时间(HH:mm:ss)")
  private String ruleClockStartTime;

  /**
   * 考勤时间规则-打卡结束时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡结束时间(HH:mm:ss)")
  private String ruleClockEndTime;

  /**
   * 考勤地址
   */
  @ApiModelProperty("考勤地址")
  private String clockPlace;

  /**
   * 打卡地点经度
   */
  @ApiModelProperty("打卡地点经度")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度
   */
  @ApiModelProperty("打卡地点地点纬度")
  private BigDecimal clockLatitude;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty("打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)")
  private String clockStatus;

  /**
   * 打卡地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus
   */
  @ApiModelProperty("打卡地点状态(ok:正常;ex:异常)")
  private String clockPlaceStatus;

  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员账号")
  private String userName;

  /**
   * 打卡人员名字
   */
  @ApiModelProperty("打卡人员名字")
  private String userRealName;

  /**
   * 异常备注
   */
  @ApiModelProperty("异常备注")
  private String exceptionRemarks;

  /**
   * 打卡是否需要拍照(Y:需要;N:不需要)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("打卡是否需要拍照(Y:需要;N:不需要)")
  private String clockPhotograph;

  /**
   * 是否以工作日进行打卡操作(Y:是;N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否以工作日进行打卡操作(Y:是;N:否)")
  private String executeAsWorkingDay;

  /**
   * 打卡时间状态-用于提示无需打卡和未到打卡时间(current_can_clock:当前可打卡;not_clock_time:未到打卡时间;today_not_need_clock:今日无需打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockTimeStatus
   */
  @ApiModelProperty("打卡时间状态-用于提示无需打卡和未到打卡时间(current_can_clock:当前可打卡;not_clock_time:未到打卡时间;today_not_need_clock:今日无需打卡)")
  private String clockTimeStatus;

  /**
   * 考勤照片
   */
  @ApiModelProperty("考勤照片")
  private List<FileVo> pictureList;
}
