package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 考勤规则范围Vo
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRulePlaceVo", description = "考勤规则范围Vo")
public class AttendanceRuleScopeVo extends UuidOpVo {

  private static final long serialVersionUID = 2107970059899286911L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  private String scopeName;

  /**
   * 范围类型(org:组织;position_level:职位级别)
   * @see AttendanceRuleScopeType
   */
  @ApiModelProperty("范围类型")
  private String scopeType;

}
