package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 考勤规则时间Vo
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRulePlaceVo", description = "考勤规则时间Vo")
public class AttendanceRuleTimeVo extends UuidOpVo {

  private static final long serialVersionUID = 417671323044983198L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 时间段序号
   */
  @ApiModelProperty("时间段序号")
  private String timeNo;

  /**
   * 上班时间
   */
  @ApiModelProperty("上班时间")
  private String onWorkTime;

  /**
   * 下班时间
   */
  @ApiModelProperty("下班时间")
  private String offWorkTime;

  /**
   * 上班打卡开始时间
   */
  @ApiModelProperty("上班打卡开始时间")
  private String onWorkClockStartTime;

  /**
   * 上班打卡结束时间
   */
  @ApiModelProperty("上班打卡结束时间")
  private String onWorkClockEndTime;

  /**
   * 下班打卡开始时间
   */
  @ApiModelProperty("下班打卡开始时间")
  private String offWorkClockStartTime;

  /**
   * 下班打卡结束时间
   */
  @ApiModelProperty("下班打卡结束时间")
  private String offWorkClockEndTime;
}
