package com.biz.crm.sfa.business.client.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 潜在客户表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_client_potential")
@Table(name = "sfa_client_potential", indexes = {
    @Index(name = "sfa_client_potential_index1", columnList = "client_code,tenant_code", unique = true)
})
@ApiModel(value = "PotentialClient", description = "潜在客户表")
@org.hibernate.annotations.Table(appliesTo = "sfa_client_potential", comment = "潜在客户表")
public class ClientPotential extends TenantFlagOpEntity {

  private static final long serialVersionUID = -4442779125977878918L;


  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "client_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '客户名称'")
  private String clientName;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  @Column(name = "client_address", length = 255, columnDefinition = "varchar(255) COMMENT '客户地址'")
  private String clientAddress;

  /**
   * 客户电话
   */
  @ApiModelProperty("客户电话")
  @Column(name = "client_phone", length = 255, columnDefinition = "varchar(255) COMMENT '客户电话'")
  private String clientPhone;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 关联人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "user_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '关联人员账号'")
  private String userName;

  /**
   * 关联人员姓名
   */
  @ApiModelProperty("人员姓名")
  @Column(name = "full_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '关联人员姓名'")
  private String fullName;

}
