package com.biz.crm.sfa.business.client.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.mapper.ClientPotentialMapper;
import com.biz.crm.sfa.business.client.sdk.dto.ClientPotentialPageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 潜在客户表(ClientPotential)表数据库访问层
 *
 * @author songjingen
 * @since 2022-07-29 09:56:25
 */
@Component
public class ClientPotentialRepository extends ServiceImpl<ClientPotentialMapper, ClientPotential> {

  @Autowired
  private ClientPotentialMapper clientPotentialMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<ClientPotential> findByConditions(Pageable pageable, ClientPotentialPageDto dto) {
    Page<ClientPotential> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ClientPotential> pageList = this.clientPotentialMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(ClientPotential::getId, ids)
        .set(ClientPotential::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 根据id集合更新删除状态
   *
   * @param idList 分页对象
   * @param delete 删除状态对象
   * @return
   */
  public void updateDelFlagStatusByIds(List<String> idList, DelFlagStatusEnum delete) {
    this.lambdaUpdate()
        .in(ClientPotential::getId, idList)
        .set(ClientPotential::getDelFlag, delete.getCode())
        .update();
  }

  /**
   * 根据类型和编码查询数据
   *
   * @param clientType
   * @param clientCodes
   * @return
   */
  public List<ClientPotential> findByClientTypeAndClientCodes(String clientType, List<String> clientCodes) {
    return this.lambdaQuery().eq(ClientPotential::getClientType, clientType)
        .in(ClientPotential::getClientCode, clientCodes)
        .list();
  }
}

