package com.biz.crm.sfa.business.client.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.sdk.dto.ClientPotentialPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 潜在客户表(ClientPotential)表服务接口
 *
 * @author songjingen
 * @since 2022-07-29 09:56:25
 */
public interface ClientPotentialService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<ClientPotential> findByConditions(Pageable pageable, ClientPotentialPageDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ClientPotential findById(String id);

  /**
   * 新增数据
   *
   * @param clientPotential 实体对象
   * @return 新增结果
   */
  ClientPotential create(ClientPotential clientPotential);

  /**
   * 修改新据
   *
   * @param clientPotential 实体对象
   * @return 修改结果
   */
  ClientPotential update(ClientPotential clientPotential);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

  /**
   * 批量新增
   *
   * @param clientPotentials
   */
  void createBatch(List<ClientPotential> clientPotentials);

  /**
   * 根据类型和编码查询数据
   *
   * @param clientType
   * @param clientCodes
   * @return
   */
  List<ClientPotential> findByClientTypeAndClientCodes(String clientType, List<String> clientCodes);
}

