package com.biz.crm.sfa.business.client.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.client.sdk.constant.ClientDictTypeConstant;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteForMdmRegister;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientContactVo;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * mdm客户维度策略
 *
 * @author songjingen
 */
@Component
public class ClientRouteForMdmStrategy implements ClientRouteStrategy {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private TerminalVoService terminalVoService;

  @Autowired
  private CustomerVoService customerVoService;

  @Autowired
  private DictDataVoService dictDataVoService;

  @Autowired
  private ClientRouteForMdmRegister clientRouteForMdmRegister;

  @Override
  public String getKey() {
    return this.clientRouteForMdmRegister.getKey();
  }

  @Override
  public List<ClientRouteInfoVo> onFindByClientCodesAndType(List<String> clientCodes, String clientType) {
    if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isEmpty(clientType)) {
      return new ArrayList<>(0);
    }
    ArrayList<ClientRouteInfoVo> vos = new ArrayList<>();
    //查询数据字典
    Map<String, List<DictDataVo>> dictTypeCodeList = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(ClientDictTypeConstant.TERMINAL_TYPE, ClientDictTypeConstant.CUSTOMER_TYPE));
    //查询终端信息
    if (ClientTypeEnum.TERMINAL.getDictCode().equals(clientType)) {
      List<TerminalVo> terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, clientCodes);
      if (!CollectionUtils.isEmpty(terminalVos)) {
        for (TerminalVo terminalVo : terminalVos) {
          ClientRouteInfoVo vo = new ClientRouteInfoVo();
          vo.setClientRoute(this.getKey());
          vo.setClientType(ClientTypeEnum.TERMINAL.getDictCode());
          vo.setClientCode(terminalVo.getTerminalCode());
          vo.setClientName(terminalVo.getTerminalName());
          vo.setLatitude(terminalVo.getLatitude());
          vo.setLongitude(terminalVo.getLongitude());
          vo.setClientAddress(StringUtils.joinWith("", terminalVo.getProvinceName(), terminalVo.getCityName(), terminalVo.getDistrictName(), terminalVo.getTerminalAddress()));
          vo.setClientSubName(findDictValue(dictTypeCodeList, ClientDictTypeConstant.TERMINAL_TYPE, terminalVo.getTerminalType()));
          List<TerminalContactVo> contacts = terminalVo.getContacts();
          if (!CollectionUtils.isEmpty(contacts)) {
            List<ClientContactVo> clientContactVos = (List<ClientContactVo>) this.nebulaToolkitService.copyCollectionByWhiteList(contacts, TerminalContactVo.class, ClientContactVo.class, HashSet.class, ArrayList.class);
            vo.setContactList(clientContactVos);
          }
          vos.add(vo);
        }
      }
    }
    //查询经销商信息
    if (ClientTypeEnum.DEALER.getDictCode().equals(clientType)) {
      List<CustomerVo> dealerVos = this.customerVoService.findByCustomerCodes(clientCodes);
      if (!CollectionUtils.isEmpty(dealerVos)) {
        for (CustomerVo dealerVo : dealerVos) {
          ClientRouteInfoVo vo = new ClientRouteInfoVo();
          vo.setClientRoute(this.getKey());
          vo.setClientType(ClientTypeEnum.DEALER.getDictCode());
          vo.setClientCode(dealerVo.getCustomerCode());
          vo.setClientName(dealerVo.getCustomerName());
          vo.setClientSubName(findDictValue(dictTypeCodeList, ClientDictTypeConstant.CUSTOMER_TYPE, dealerVo.getCustomerType()));
          vo.setLatitude(dealerVo.getLatitude());
          vo.setLongitude(dealerVo.getLongitude());
          vo.setClientAddress(StringUtils.joinWith("", dealerVo.getProvinceName(), dealerVo.getCityName(), dealerVo.getDistrictName(), dealerVo.getRegisteredAddress()));
          List<CustomerContactVo> contacts = dealerVo.getContactList();
          if (!CollectionUtils.isEmpty(contacts)) {
            List<ClientContactVo> clientContactVos = (List<ClientContactVo>) this.nebulaToolkitService.copyCollectionByWhiteList(contacts, CustomerContactVo.class, ClientContactVo.class, HashSet.class, ArrayList.class);
            vo.setContactList(clientContactVos);
          }
          vos.add(vo);
        }
      }
    }
    return vos;
  }

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param code
   * @return
   */
  public static String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
        vos.stream()
            .filter(a -> a.getDictCode().equals(code))
            .map(DictDataVo::getDictValue)
            .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }

}
