/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.client.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.service.ClientPotentialService;
import com.biz.crm.sfa.business.client.sdk.dto.ClientPotentialPageDto;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/client/clientPotential"})
@Api(tags={"\u5ba2\u6237\u7ba1\u7406\uff1aClientPotential\uff1a\u6f5c\u5728\u5ba2\u6237\u8868"})
public class ClientPotentialController {
    private static final Logger log = LoggerFactory.getLogger(ClientPotentialController.class);
    @Autowired
    private ClientPotentialService clientPotentialService;
    @Autowired
    private List<ClientRouteRegister> clientRouteRegisters;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ClientPotential>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="clientPotential", value="\u6f5c\u5728\u5ba2\u6237\u8868") ClientPotentialPageDto dto) {
        try {
            Page<ClientPotential> page = this.clientPotentialService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ClientPotential> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ClientPotential clientPotential = this.clientPotentialService.findById(id);
            return Result.ok((Object)((Object)clientPotential));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<ClientPotential> create(@ApiParam(name="clientPotential", value="\u6f5c\u5728\u5ba2\u6237\u8868") @RequestBody ClientPotential clientPotential) {
        try {
            ClientPotential result = this.clientPotentialService.create(clientPotential);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<ClientPotential> update(@ApiParam(name="clientPotential", value="\u6f5c\u5728\u5ba2\u6237\u8868") @RequestBody ClientPotential clientPotential) {
        try {
            ClientPotential result = this.clientPotentialService.update(clientPotential);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.clientPotentialService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.clientPotentialService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.clientPotentialService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u7ef4\u5ea6")
    @GetMapping(value={"findClientRoutes"})
    public Result<Map<String, String>> findClientRoutes() {
        try {
            if (CollectionUtils.isEmpty(this.clientRouteRegisters)) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (ClientRouteRegister clientRouteRegister : this.clientRouteRegisters) {
                map.put(clientRouteRegister.getKey(), clientRouteRegister.getName());
            }
            return Result.ok(map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

