/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.client.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.repository.ClientPotentialRepository;
import com.biz.crm.sfa.business.client.local.service.ClientPotentialService;
import com.biz.crm.sfa.business.client.sdk.dto.ClientPotentialPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="clientPotentialService")
public class ClientPotentialServiceImpl
implements ClientPotentialService {
    @Autowired
    private ClientPotentialRepository clientPotentialRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<ClientPotential> findByConditions(Pageable pageable, ClientPotentialPageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ClientPotentialPageDto();
        }
        return this.clientPotentialRepository.findByConditions(pageable, dto);
    }

    @Override
    public ClientPotential findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ClientPotential)((Object)this.clientPotentialRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public ClientPotential create(ClientPotential clientPotential) {
        this.createValidate(clientPotential);
        this.clientPotentialRepository.saveOrUpdate((Object)clientPotential);
        return clientPotential;
    }

    @Override
    @Transactional
    public ClientPotential update(ClientPotential clientPotential) {
        this.updateValidate(clientPotential);
        ClientPotential current = (ClientPotential)((Object)this.clientPotentialRepository.getById((Serializable)((Object)clientPotential.getId())));
        Validate.notNull((Object)((Object)current), (String)"\u672a\u67e5\u8be2\u5230\u8981\u7f16\u8f91\u7684\u6570\u636e", (Object[])new Object[0]);
        BeanUtil.copyProperties((Object)((Object)clientPotential), (Object)((Object)current), (String[])new String[]{"id", "delFlag", "enableStatus", "clientCode", "createTime", "createAccount", "createName"});
        this.clientPotentialRepository.saveOrUpdate((Object)current);
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.clientPotentialRepository.updateDelFlagStatusByIds(idList, DelFlagStatusEnum.DELETE);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.clientPotentialRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.clientPotentialRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void createBatch(List<ClientPotential> clientPotentials) {
        Validate.isTrue((!CollectionUtils.isEmpty(clientPotentials) ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        clientPotentials.forEach(this::createValidate);
        this.clientPotentialRepository.saveBatch(clientPotentials);
    }

    @Override
    public List<ClientPotential> findByClientTypeAndClientCodes(String clientType, List<String> clientCodes) {
        if (StringUtils.isBlank((CharSequence)clientType) || CollectionUtils.isEmpty(clientCodes)) {
            return new ArrayList<ClientPotential>(0);
        }
        return this.clientPotentialRepository.findByClientTypeAndClientCodes(clientType, clientCodes);
    }

    private void createValidate(ClientPotential clientPotential) {
        Validate.notNull((Object)((Object)clientPotential), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        clientPotential.setId(null);
        clientPotential.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        clientPotential.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        clientPotential.setTenantCode(TenantUtils.getTenantCode());
        clientPotential.setClientCode((String)this.generateCodeService.generateCode("QZKH", 1).get(0));
        Validate.notBlank((CharSequence)clientPotential.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getFullName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(ClientPotential clientPotential) {
        Validate.notNull((Object)((Object)clientPotential), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getClientType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getFullName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientPotential.getUserName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

