/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.client.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteForMdmRegister;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientContactVo;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ClientRouteForMdmStrategy
implements ClientRouteStrategy {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private DictDataVoService dictDataVoService;
    @Autowired
    private ClientRouteForMdmRegister clientRouteForMdmRegister;

    public String getKey() {
        return this.clientRouteForMdmRegister.getKey();
    }

    public List<ClientRouteInfoVo> onFindByClientCodesAndType(List<String> clientCodes, String clientType) {
        List dealerVos;
        List clientContactVos;
        List contacts;
        ClientRouteInfoVo vo;
        List terminalVos;
        if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isEmpty((CharSequence)clientType)) {
            return new ArrayList<ClientRouteInfoVo>(0);
        }
        ArrayList<ClientRouteInfoVo> vos = new ArrayList<ClientRouteInfoVo>();
        Map dictTypeCodeList = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"terminal_type", "customer_type"}));
        if (ClientTypeEnum.TERMINAL.getDictCode().equals(clientType) && !CollectionUtils.isEmpty((Collection)(terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, clientCodes)))) {
            for (TerminalVo terminalVo : terminalVos) {
                vo = new ClientRouteInfoVo();
                vo.setClientRoute(this.getKey());
                vo.setClientType(ClientTypeEnum.TERMINAL.getDictCode());
                vo.setClientCode(terminalVo.getTerminalCode());
                vo.setClientName(terminalVo.getTerminalName());
                vo.setLatitude(terminalVo.getLatitude());
                vo.setLongitude(terminalVo.getLongitude());
                vo.setClientAddress(StringUtils.joinWith((String)"", (Object[])new Object[]{terminalVo.getProvinceName(), terminalVo.getCityName(), terminalVo.getDistrictName(), terminalVo.getTerminalAddress()}));
                vo.setClientSubName(ClientRouteForMdmStrategy.findDictValue(dictTypeCodeList, "terminal_type", terminalVo.getTerminalType()));
                contacts = terminalVo.getContacts();
                if (!CollectionUtils.isEmpty((Collection)contacts)) {
                    clientContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contacts, TerminalContactVo.class, ClientContactVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setContactList(clientContactVos);
                }
                vos.add(vo);
            }
        }
        if (ClientTypeEnum.DEALER.getDictCode().equals(clientType) && !CollectionUtils.isEmpty((Collection)(dealerVos = this.customerVoService.findByCustomerCodes(clientCodes)))) {
            for (CustomerVo dealerVo : dealerVos) {
                vo = new ClientRouteInfoVo();
                vo.setClientRoute(this.getKey());
                vo.setClientType(ClientTypeEnum.DEALER.getDictCode());
                vo.setClientCode(dealerVo.getCustomerCode());
                vo.setClientName(dealerVo.getCustomerName());
                vo.setClientSubName(ClientRouteForMdmStrategy.findDictValue(dictTypeCodeList, "customer_type", dealerVo.getCustomerType()));
                vo.setLatitude(dealerVo.getLatitude());
                vo.setLongitude(dealerVo.getLongitude());
                vo.setClientAddress(StringUtils.joinWith((String)"", (Object[])new Object[]{dealerVo.getProvinceName(), dealerVo.getCityName(), dealerVo.getDistrictName(), dealerVo.getRegisteredAddress()}));
                contacts = dealerVo.getContactList();
                if (!CollectionUtils.isEmpty((Collection)contacts)) {
                    clientContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)contacts, CustomerContactVo.class, ClientContactVo.class, HashSet.class, ArrayList.class, new String[0]);
                    vo.setContactList(clientContactVos);
                }
                vos.add(vo);
            }
        }
        return vos;
    }

    public static String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

