/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.client.local.service.notifier;

import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.sfa.business.client.local.entity.ClientPotential;
import com.biz.crm.sfa.business.client.local.service.ClientPotentialService;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteForPotentialRegister;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientContactVo;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ClientRouteForPotentialStrategy
implements ClientRouteStrategy {
    @Autowired
    private ClientPotentialService clientPotentialService;
    @Autowired
    private ClientRouteForPotentialRegister clientRouteForPotentialRegister;

    public String getKey() {
        return this.clientRouteForPotentialRegister.getKey();
    }

    public List<ClientRouteInfoVo> onFindByClientCodesAndType(List<String> clientCodes, String clientType) {
        if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isEmpty((CharSequence)clientType)) {
            return new ArrayList<ClientRouteInfoVo>(0);
        }
        ArrayList<ClientRouteInfoVo> vos = new ArrayList<ClientRouteInfoVo>();
        List<ClientPotential> clientPotentials = this.clientPotentialService.findByClientTypeAndClientCodes(clientType, clientCodes);
        if (!CollectionUtils.isEmpty(clientPotentials)) {
            for (ClientPotential clientPotential : clientPotentials) {
                ClientRouteInfoVo vo = new ClientRouteInfoVo();
                BeanUtil.copyProperties((Object)((Object)clientPotential), (Object)vo, (String[])new String[0]);
                vo.setClientRoute(this.getKey());
                ArrayList<ClientContactVo> clientContactVos = new ArrayList<ClientContactVo>();
                String clientPhone = clientPotential.getClientPhone();
                if (StringUtils.isNotBlank((CharSequence)clientPhone)) {
                    String[] split = clientPhone.split(";");
                    for (int i = 0; i < split.length; ++i) {
                        ClientContactVo clientContactVo = new ClientContactVo();
                        clientContactVo.setContactName(clientPotential.getClientName());
                        clientContactVo.setContactPhone(split[i]);
                        clientContactVos.add(clientContactVo);
                    }
                }
                vo.setContactList(clientContactVos);
                vos.add(vo);
            }
        }
        return vos;
    }
}

