package com.biz.crm.sfa.business.client.sdk.register;

/**
 * 拜访计划客户维度注册器
 * 所有拜访计划客户维度模块实现该接口，让拜访计划模块知道系统中已经存在的客户维度实现
 *
 * @author songjignen
 */
public interface ClientRouteRegister {

  /**
   * 维度中文名称
   * 具体维度实现该方法，告知拜访计划本维度的中文名（注意，具体的客户维度中，设定的该信息不能重复）
   *
   * @return
   */
  String getName();

  /**
   * 维度key
   * 具体维度实现该方法，告知拜访计划本维度的英文key（注意，具体的客户维度中，设定的该信息不能重复）
   *
   * @return
   */
  String getKey();

}
