package com.biz.crm.sfa.business.client.sdk.strategy;


import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;

import java.util.List;

/**
 * 拜访计划客户维度策略
 *
 * @author songjingen
 */
public interface ClientRouteStrategy {

  /**
   * 维度key
   * {@link ClientRouteRegister#getKey()}
   *
   * @return
   */
  String getKey();

  /**
   * 通过客户编码和类型查询数据
   *
   * @param clientCodes
   * @param clientType
   * @return
   */
  default List<ClientRouteInfoVo> onFindByClientCodesAndType(List<String> clientCodes, String clientType) {
    return null;
  }

}
