package com.biz.crm.sfa.business.client.sdk.vo;

import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 客户维度信息
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitPlanClientRouteInfoVo", description = "客户维度信息")
public class ClientRouteInfoVo {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类
   */
  @ApiModelProperty("客户细类")
  private String clientSubName;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  private String clientAddress;

  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<ClientContactVo> contactList;

}
