package com.biz.crm.sfa.business.client.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 客户类型枚举
 */
public enum ClientTypeEnum {

  TERMINAL("terminal", "terminal", "终端", "1"),
  DEALER("dealer", "dealer", "经销商", "2"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ClientTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ClientTypeEnum
   *
   * @param key
   * @return
   */
  public static ClientTypeEnum getByKey(String key) {
    return Arrays.stream(ClientTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 ClientTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static ClientTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(ClientTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

  /**
   * 通过 value 获取 ClientTypeEnum
   *
   * @param value
   * @return
   */
  public static ClientTypeEnum getByValue(String value) {
    return Arrays.stream(ClientTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value)).findFirst().orElse(null);
  }

}
