package com.biz.crm.sfa.business.conclusion.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionService;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "工作总结：conclusion:工作总结")
@RequestMapping("/v1/conclusion/conclusion")
public class ConclusionController {

  @Autowired
  private ConclusionService conclusionService;

  /**
   * 创建工作总结
   *
   * @param dto 工作总结DTO
   * @return 创建结果
   */
  @ApiOperation("创建工作总结/心得")
  @PostMapping("")
  public Result<ConclusionEntity> create(@RequestBody ConclusionDto dto) {
    return Result.ok(this.conclusionService.create(dto));
  }
}
