package com.biz.crm.sfa.business.conclusion.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionVoService;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "工作总结：conclusionVo:工作总结查询")
@RequestMapping("/v1/conclusion/conclusionVo")
public class ConclusionVoController {

  @Autowired
  private ConclusionVoService conclusionVoService;


  /**
   * 分页查询工作总结列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 查询列表
   */
  @ApiOperation("分页查询工作总结列表")
  @GetMapping("/findByConditions")
  public Result<Page<ConclusionVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                     @ApiParam(name = "conclusionListDto", value = "分页Dto") ConclusionListDto dto) {
    return Result.ok(this.conclusionVoService.findByConditions(pageable,dto));
  }

  /**
   * 根据id查询工作总结详情
   * @param id i
   * @return 工作总结详情
   */
  @ApiOperation("根据id查询工作总结")
  @GetMapping("/findById")
  public Result<ConclusionVo> findById(@RequestParam("id") String id) {
    return Result.ok(this.conclusionVoService.findById(id));
  }

  /**
   * 分页查询艾特我的列表
   * @param pageable 分页信息
   * @return 查询列表
   */
  @ApiOperation("分页查询艾特我的列表")
  @GetMapping("/findCallCurrentByConditions")
  public Result<Page<ConclusionVo>> findCallCurrentByConditions(@PageableDefault(50) Pageable pageable) {
    return Result.ok(this.conclusionVoService.findCallCurrentByConditions(pageable));
  }
}
