package com.biz.crm.sfa.business.conclusion.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 工作总结实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConclusionEntity", description = "工作总结实体类")
@Entity
@TableName("sfa_conclusion")
@Table(name = "sfa_conclusion")
@org.hibernate.annotations.Table(appliesTo = "sfa_conclusion", comment = "工作总结表")
public class ConclusionEntity extends TenantFlagOpEntity {

  /**
   * 总结类别：日报/周报/月报/心得
   */
  @Column(name = "conclusion_type", length = 32, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '总结类别：日报/周报/月报/心得'")
  @ApiModelProperty("总结类别：日报/周报/月报/心得")
  private String conclusionType;

  /**
   * 总结内容
   */
  @Column(name = "conclusion_content", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '总结内容'")
  @ApiModelProperty("总结内容")
  private String conclusionContent;

  /**
   * 工作计划
   */
  @Column(name = "work_plan", length = 200, columnDefinition = "VARCHAR(200) COMMENT '工作计划'")
  @ApiModelProperty("工作计划")
  private String workPlan;

  /**
   * 可见范围类别
   */
  @Column(name = "visible_scope_type", length = 32, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '可见范围类别'")
  @ApiModelProperty("可见范围类别")
 private String visibleScopeType;

  /**
   * 位置信息
   */
  @Column(name = "conclusion_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '位置信息'")
  @ApiModelProperty("位置信息")
  private String conclusionAddress;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", length = 32, columnDefinition = "VARCHAR(32) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private String longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", length = 32, columnDefinition = "VARCHAR(32) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private String latitude;

  /**
   * 职位编码
   */
  @Column(name = "post_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 组织编码
   */
  @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @Column(name = "post_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '职位名称'")
  @ApiModelProperty("职位编码")
  private String postName;

  /**
   * 组织编码
   */
  @Column(name = "org_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称'")
  @ApiModelProperty("组织编码")
  private String orgName;

  /**
   * 上级职位编码
   */
  @Column(name = "parent_post_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级职位编码'")
  @ApiModelProperty("上级职位编码")
  private String parentPostCode;

  /**
   * 上级职位名称
   */
  @Column(name = "parent_post_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级职位名称'")
  @ApiModelProperty("上级职位名称")
  private String parentPostName;

}
