package com.biz.crm.sfa.business.conclusion.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 工作总结文件实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConclusionEntity", description = "工作总结文件实体类")
@Entity
@TableName("sfa_conclusion_file")
@Table(name = "sfa_conclusion_file")
@org.hibernate.annotations.Table(appliesTo = "sfa_conclusion_file", comment = "工作总结文件表")
public class ConclusionFileEntity extends FileEntity {

  /**
   * 工作总结ID
   */
  @Column(name = "conclusion_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '工作总结ID'")
  @ApiModelProperty("工作计划")
  private String conclusionId;



}
