package com.biz.crm.sfa.business.conclusion.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 工作总结实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ConclusionScopeEntity", description = "工作总结可见范围实体类")
@Entity
@TableName("sfa_conclusion_scope")
@Table(name = "sfa_conclusion_scope")
@org.hibernate.annotations.Table(appliesTo = "sfa_conclusion_scope", comment = "工作总结可见范围表")
public class ConclusionScopeEntity extends UuidEntity {

  /**
   * 工作总结ID
   */
  @Column(name = "conclusion_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '工作总结ID'")
  @ApiModelProperty("工作总结ID")
  private String conclusionId;

  /**
   * 用户编码
   */
  @Column(name = "user_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT 'userCode'")
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 用户姓名
   */
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'userName'")
  @ApiModelProperty("用户名称")
  private String userName;


}
