package com.biz.crm.sfa.business.conclusion.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;


/**
 * 工作总结mapper
 *
 * @author jerry7
 */
public interface ConclusionMapper extends BaseMapper<ConclusionEntity> {
  /**
   * 分页查询工作总结列表
   *
   * @param page 分页参数
   * @param dto  查询参数
   * @return 查询结果
   */
  Page<ConclusionEntity> findByConditions(Page<ConclusionEntity> page, ConclusionListDto dto);

  /**
   * 分页查询艾特我的列表
   *
   * @param page 分页参数
   * @param dto  查询参数
   * @return 查询结果
   */
  Page<ConclusionEntity> findCallCurrentByConditions(Page<ConclusionEntity> page, ConclusionListDto dto);
}
