package com.biz.crm.sfa.business.conclusion.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionFileEntity;
import com.biz.crm.sfa.business.conclusion.local.mapper.ConclusionFileMapper;
import com.biz.crm.sfa.business.conclusion.local.mapper.ConclusionMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 工作总结文件操作类
 *
 * @author jerry7
 */
@Component
public class ConclusionFileRepository extends ServiceImpl<ConclusionFileMapper, ConclusionFileEntity> {

  /**
   * 根据工作总结ID查询相关附件
   * @param conclusionId 工作总结ID
   * @return 附件列表
   */
  public List<ConclusionFileEntity> findByConclusionId(String conclusionId) {
    return this.lambdaQuery().eq(ConclusionFileEntity::getConclusionId, conclusionId).list();
  }
}
