package com.biz.crm.sfa.business.conclusion.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.mapper.ConclusionMapper;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.swing.plaf.PanelUI;
import java.util.List;


/**
 * 工作总结数据库操作类
 *
 * @author jerry7
 */
@Component
public class ConclusionRepository extends ServiceImpl<ConclusionMapper, ConclusionEntity> {

  /**
   * 分页查询工作总结列表
   *
   * @param pageable 分页参数
   * @param dto      查询参数
   * @return 查询结果
   */
  public Page<ConclusionEntity> findByConditions(Pageable pageable, ConclusionListDto dto) {
    Page<ConclusionEntity> conclusionEntityPage = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(conclusionEntityPage, dto);
  }


  /**
   * 根据时间段和总结类别查询工作总结列表
   *
   * @param dto 查询参数
   * @return 查询结果
   */
  public List<ConclusionEntity> findByTimesAndType(ConclusionListDto dto) {
    return this.lambdaQuery().eq(ConclusionEntity::getConclusionType, dto.getConclusionType())
            .gt(ConclusionEntity::getCreateTime, dto.getCreateTimeStart())
            .lt(ConclusionEntity::getCreateTime, dto.getCreateTimeEnd())
            .eq(ConclusionEntity::getCreateName,dto.getCreateName())
            .list();
  }

  /**
   * 分页查询艾特我的列表
   *
   * @param pageable 分页参数
   * @param dto  查询参数
   * @return 查询结果
   */
  public Page<ConclusionEntity> findCallCurrentByConditions(Pageable pageable, ConclusionListDto dto){
    Page<ConclusionEntity> conclusionEntityPage = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findCallCurrentByConditions(conclusionEntityPage, dto);
  }

}
