package com.biz.crm.sfa.business.conclusion.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionVo;
import org.springframework.data.domain.Pageable;

/**
 * 工作总结VO接口类
 *
 * @author jerry7
 */
public interface ConclusionVoService {

  /**
   * 分页查询工作总结
   *
   * @param pageable 分页参数
   * @param dto      查询参数
   * @return 创建结果
   */
  Page<ConclusionVo> findByConditions(Pageable pageable, ConclusionListDto dto);

  /**
   * 根据id查询工作总结详情
   * @param id id
   * @return 工作总结
   */
  ConclusionVo findById(String id);

  /**
   * 分页查询艾特我的列表
   *
   * @param pageable 分页参数
   * @return 创建结果
   */
  Page<ConclusionVo> findCallCurrentByConditions(Pageable pageable);
}
