package com.biz.crm.sfa.business.conclusion.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionFileEntity;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionFileRepository;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionRepository;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionVoService;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import com.biz.crm.sfa.business.conclusion.sdk.enums.ConclusionQueryScopeEnum;
import com.biz.crm.sfa.business.conclusion.sdk.enums.ConclusionTypeEnum;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionFileVo;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 工作总结接口实现类
 *
 * @author jerry7
 */
@Slf4j
@Service
public class ConclusionVoServiceImpl implements ConclusionVoService {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private ConclusionRepository conclusionRepository;

  @Autowired
  private ConclusionFileRepository conclusionFileRepository;

  @Autowired
  private LoginUserService loginUserService;


  @Override
  public Page<ConclusionVo> findByConditions(Pageable pageable, ConclusionListDto dto) {
    Validate.notNull(dto, "请求参数不能为空");
    if (StringUtils.isEmpty(dto.getVisibleScopeType())) {
      dto.setVisibleScopeType(ConclusionQueryScopeEnum.CONCLUSION_TYPE_ALL.getDictCode());
    }
    //添加参数，对于我的发起，以及我的下属，同组织
    LoginUserDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setUserName(loginUserDetails.getUsername());
    dto.setParentPostCode(loginUserDetails.getPostCode());
    dto.setOrgCode(loginUserDetails.getOrgCode());
    dto.setCreateAccount(loginUserDetails.getAccount());
    Page<ConclusionEntity> conclusionEntityPage = this.conclusionRepository.findByConditions(pageable, dto);
    Page<ConclusionVo> pageResult = new Page<>(conclusionEntityPage.getCurrent(), conclusionEntityPage.getSize(), conclusionEntityPage.getTotal());
    if (CollectionUtils.isNotEmpty(conclusionEntityPage.getRecords())) {
      pageResult.setRecords((List<ConclusionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(conclusionEntityPage.getRecords(), ConclusionEntity.class
              , ConclusionVo.class, HashSet.class, ArrayList.class));
      //查询并组装附件
      pageResult.getRecords().forEach(vo -> {
        vo.setConclusionFileList(this.findConclusionFileById(vo.getId()));
      });
    }
    return pageResult;
  }

  @Override
  public ConclusionVo findById(String id) {
    ConclusionEntity conclusionEntity = this.conclusionRepository.getById(id);
    if (ObjectUtils.isEmpty(conclusionEntity)) {
      return null;
    }
    ConclusionVo conclusionVo = this.nebulaToolkitService.copyObjectByWhiteList(conclusionEntity, ConclusionVo.class, HashSet.class, ArrayList.class);
    conclusionVo.setConclusionFileList(this.findConclusionFileById(conclusionEntity.getId()));
    return conclusionVo;
  }

  @Override
  public Page<ConclusionVo> findCallCurrentByConditions(Pageable pageable) {
    ConclusionListDto dto = new ConclusionListDto();
    LoginUserDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setCreateAccount(loginUserDetails.getAccount());
    Page<ConclusionEntity> conclusionEntityPage = this.conclusionRepository.findCallCurrentByConditions(pageable, dto);
    Page<ConclusionVo> pageResult = new Page<>(conclusionEntityPage.getCurrent(), conclusionEntityPage.getSize(), conclusionEntityPage.getTotal());
    if (CollectionUtils.isNotEmpty(conclusionEntityPage.getRecords())) {
      pageResult.setRecords((List<ConclusionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(conclusionEntityPage.getRecords(), ConclusionEntity.class
              , ConclusionVo.class, HashSet.class, ArrayList.class));
      //查询并组装附件
      pageResult.getRecords().forEach(vo -> {
        vo.setConclusionFileList(this.findConclusionFileById(vo.getId()));
      });
    }
    return pageResult;
  }

  /**
   * 根据工作总结id查询附件列表
   *
   * @param conclusionId 工作总结id
   * @return 附件列表
   */
  private List<ConclusionFileVo> findConclusionFileById(String conclusionId) {
    List<ConclusionFileEntity> fileEntities = this.conclusionFileRepository.findByConclusionId(conclusionId);
    if (CollectionUtils.isNotEmpty(fileEntities)) {
      return (List<ConclusionFileVo>) this.nebulaToolkitService.copyCollectionByWhiteList(fileEntities, ConclusionFileEntity.class, ConclusionFileVo.class, HashSet.class, ArrayList.class);
    }
    return Lists.newArrayList();
  }
}
