/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.conclusion.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionCallUserEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionFileEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionScopeEntity;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionCallUserRepository;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionFileRepository;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionRepository;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionScopeRepository;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionService;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionDto;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionFileDto;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import com.biz.crm.sfa.business.conclusion.sdk.enums.ConclusionScopeEnum;
import com.biz.crm.sfa.business.conclusion.sdk.enums.ConclusionTypeEnum;
import com.biz.crm.workflow.sdk.dto.PositionInfoDto;
import com.biz.crm.workflow.sdk.listener.PositionInfoListener;
import com.biz.crm.workflow.sdk.vo.PositionVo;
import com.biz.crm.workflow.sdk.vo.response.PositionInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConclusionServiceImpl
implements ConclusionService {
    private static final Logger log = LoggerFactory.getLogger(ConclusionServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ConclusionRepository conclusionRepository;
    @Autowired
    private ConclusionFileRepository conclusionFileRepository;
    @Autowired
    private ConclusionScopeRepository conclusionScopeRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ConclusionCallUserRepository conclusionCallUserRepository;

    @Override
    @Transactional
    public ConclusionEntity create(ConclusionDto dto) {
        this.validateConclusion(dto);
        ConclusionEntity conclusionEntity = (ConclusionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ConclusionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.conclusionRepository.save((Object)conclusionEntity);
        if (CollectionUtils.isNotEmpty((Collection)dto.getConclusionFileList())) {
            List fileEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getConclusionFileList(), ConclusionFileDto.class, ConclusionFileEntity.class, HashSet.class, ArrayList.class, new String[0]);
            fileEntities.forEach(file -> file.setConclusionId(conclusionEntity.getId()));
            this.conclusionFileRepository.saveOrUpdateBatch(fileEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVisibleScope())) {
            ArrayList scopeEntityList = Lists.newArrayList();
            dto.getVisibleScope().forEach(userCode -> {
                ConclusionScopeEntity scopeEntity = new ConclusionScopeEntity();
                scopeEntity.setConclusionId(conclusionEntity.getId());
                scopeEntity.setUserCode((String)userCode);
                scopeEntityList.add(scopeEntity);
            });
            this.conclusionScopeRepository.saveBatch(scopeEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getCallUserSet())) {
            ArrayList callUserEntities = Lists.newArrayList();
            dto.getCallUserSet().forEach(userCode -> {
                ConclusionCallUserEntity callUser = new ConclusionCallUserEntity();
                callUser.setConclusionId(conclusionEntity.getId());
                callUser.setUserCode((String)userCode);
                callUserEntities.add(callUser);
            });
            this.conclusionCallUserRepository.saveBatch(callUserEntities);
        }
        return conclusionEntity;
    }

    private void validateConclusion(ConclusionDto dto) {
        Validate.notNull((Object)dto, (String)"\u5de5\u4f5c\u603b\u7ed3\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getConclusionType(), (String)"\u5de5\u4f5c\u603b\u7ed3\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ConclusionTypeEnum typeEnum = ConclusionTypeEnum.getByKey((String)dto.getConclusionType());
        Validate.notNull((Object)typeEnum, (String)"\u5de5\u4f5c\u603b\u7ed3\u7c7b\u522b\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getConclusionFileList())) {
            Validate.isTrue((dto.getConclusionFileList().size() < 6 ? 1 : 0) != 0, (String)"\u9644\u4ef6\u6570\u91cf\u8d85\u51fa\u9650\u5236", (Object[])new Object[0]);
        }
        Validate.notNull((Object)dto.getVisibleScopeType(), (String)"\u5de5\u4f5c\u603b\u7ed3\u53ef\u89c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ConclusionScopeEnum scopeEnum = ConclusionScopeEnum.getByDictCode((String)dto.getVisibleScopeType());
        Validate.notNull((Object)scopeEnum, (String)"\u53ef\u89c1\u8303\u56f4\u7c7b\u522b\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        if (scopeEnum == ConclusionScopeEnum.CONCLUSION_TYPE_COLLEAGUE) {
            Validate.isTrue((dto.getVisibleScope().size() > 0 ? 1 : 0) != 0, (String)"\u81ea\u5b9a\u4e49\u53ef\u89c1\u8303\u56f4\u4eba\u6570\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        }
        Validate.notNull((Object)dto.getConclusionContent(), (String)"\u603b\u7ed3/\u5fc3\u5f97\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getConclusionContent().length() < 201 ? 1 : 0) != 0, (String)"\u603b\u7ed3/\u5fc3\u5f97\u5185\u5bb9\u8d85\u8fc7200\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getWorkPlan())) {
            Validate.isTrue((dto.getWorkPlan().length() < 201 ? 1 : 0) != 0, (String)"\u660e\u65e5\u8ba1\u5212\u5185\u5bb9\u8d85\u8fc7200\uff01", (Object[])new Object[0]);
        }
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        if (!ConclusionTypeEnum.CONCLUSION_TYPE_EXPERIENCE.getDictCode().equals(dto.getConclusionType())) {
            ConclusionListDto conclusionListDto = new ConclusionListDto();
            conclusionListDto.setCreateName(loginUserDetails.getUsername());
            conclusionListDto.setCreateTimeStart(this.getCreateTimeStart(dto.getConclusionType()));
            conclusionListDto.setCreateTimeEnd(this.getCreateTimeEnd(dto.getConclusionType()));
            conclusionListDto.setConclusionType(dto.getConclusionType());
            List<ConclusionEntity> conclusionEntities = this.conclusionRepository.findByTimesAndType(conclusionListDto);
            Validate.isTrue((boolean)CollectionUtils.isEmpty(conclusionEntities), (String)"\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u5df2\u63d0\u4ea4\u5de5\u4f5c\u603b\u7ed3\uff01", (Object[])new Object[0]);
        }
        dto.setCreateAccount(loginUserDetails.getAccount());
        dto.setCreateTime((Date)DateUtil.date());
        dto.setCreateName(loginUserDetails.getUsername());
        dto.setOrgCode(loginUserDetails.getOrgCode());
        dto.setOrgName(loginUserDetails.getOrgName());
        dto.setPostCode(loginUserDetails.getPostCode());
        dto.setPostName(loginUserDetails.getPostName());
        SerializableBiConsumer & Serializable sf = PositionInfoListener::onFindByIdsOrCodes;
        PositionInfoResponse response = (PositionInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)PositionInfoDto.builder().roleCodes((List)Lists.newArrayList((Object[])new String[]{loginUserDetails.getPostCode()})).build(), PositionInfoListener.class, (SerializableBiConsumer)sf);
        if (ObjectUtils.isNotEmpty((Object)response) && CollectionUtils.isNotEmpty((Collection)response.getPositionVos())) {
            PositionVo positionVo = (PositionVo)response.getPositionVos().get(0);
            dto.setParentPostCode(positionVo.getParentCode());
        }
    }

    private Date getCreateTimeStart(String conclusionTypeEnum) {
        ConclusionTypeEnum typeEnum = ConclusionTypeEnum.getByKey((String)conclusionTypeEnum);
        if (ObjectUtils.isEmpty((Object)typeEnum)) {
            return null;
        }
        switch (typeEnum) {
            case CONCLUSION_TYPE_DAILY: {
                return DateUtil.beginOfDay((Date)DateUtil.date());
            }
            case CONCLUSION_TYPE_WEEKLY: {
                return DateUtil.beginOfWeek((Date)DateUtil.date());
            }
            case CONCLUSION_TYPE_MONTHLY: {
                return DateUtil.beginOfMonth((Date)DateUtil.date());
            }
        }
        return null;
    }

    private Date getCreateTimeEnd(String conclusionTypeEnum) {
        ConclusionTypeEnum typeEnum = ConclusionTypeEnum.getByKey((String)conclusionTypeEnum);
        if (ObjectUtils.isEmpty((Object)typeEnum)) {
            return null;
        }
        switch (typeEnum) {
            case CONCLUSION_TYPE_DAILY: {
                return DateUtil.endOfDay((Date)DateUtil.date());
            }
            case CONCLUSION_TYPE_WEEKLY: {
                return DateUtil.endOfWeek((Date)DateUtil.date());
            }
            case CONCLUSION_TYPE_MONTHLY: {
                return DateUtil.endOfMonth((Date)DateUtil.date());
            }
        }
        return null;
    }
}

