/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.conclusion.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionEntity;
import com.biz.crm.sfa.business.conclusion.local.entity.ConclusionFileEntity;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionFileRepository;
import com.biz.crm.sfa.business.conclusion.local.repository.ConclusionRepository;
import com.biz.crm.sfa.business.conclusion.local.service.ConclusionVoService;
import com.biz.crm.sfa.business.conclusion.sdk.dto.ConclusionListDto;
import com.biz.crm.sfa.business.conclusion.sdk.enums.ConclusionQueryScopeEnum;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionFileVo;
import com.biz.crm.sfa.business.conclusion.sdk.vo.ConclusionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ConclusionVoServiceImpl
implements ConclusionVoService {
    private static final Logger log = LoggerFactory.getLogger(ConclusionVoServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ConclusionRepository conclusionRepository;
    @Autowired
    private ConclusionFileRepository conclusionFileRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<ConclusionVo> findByConditions(Pageable pageable, ConclusionListDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getVisibleScopeType())) {
            dto.setVisibleScopeType(ConclusionQueryScopeEnum.CONCLUSION_TYPE_ALL.getDictCode());
        }
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginUserDetails.getUsername());
        dto.setParentPostCode(loginUserDetails.getPostCode());
        dto.setOrgCode(loginUserDetails.getOrgCode());
        dto.setCreateAccount(loginUserDetails.getAccount());
        Page<ConclusionEntity> conclusionEntityPage = this.conclusionRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(conclusionEntityPage.getCurrent(), conclusionEntityPage.getSize(), conclusionEntityPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)conclusionEntityPage.getRecords())) {
            pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)conclusionEntityPage.getRecords(), ConclusionEntity.class, ConclusionVo.class, HashSet.class, ArrayList.class, new String[0]));
            pageResult.getRecords().forEach(vo -> vo.setConclusionFileList(this.findConclusionFileById(vo.getId())));
        }
        return pageResult;
    }

    @Override
    public ConclusionVo findById(String id) {
        ConclusionEntity conclusionEntity = (ConclusionEntity)((Object)this.conclusionRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)conclusionEntity))) {
            return null;
        }
        ConclusionVo conclusionVo = (ConclusionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)conclusionEntity, ConclusionVo.class, HashSet.class, ArrayList.class, new String[0]);
        conclusionVo.setConclusionFileList(this.findConclusionFileById(conclusionEntity.getId()));
        return conclusionVo;
    }

    @Override
    public Page<ConclusionVo> findCallCurrentByConditions(Pageable pageable) {
        ConclusionListDto dto = new ConclusionListDto();
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setCreateAccount(loginUserDetails.getAccount());
        Page<ConclusionEntity> conclusionEntityPage = this.conclusionRepository.findCallCurrentByConditions(pageable, dto);
        Page pageResult = new Page(conclusionEntityPage.getCurrent(), conclusionEntityPage.getSize(), conclusionEntityPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)conclusionEntityPage.getRecords())) {
            pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)conclusionEntityPage.getRecords(), ConclusionEntity.class, ConclusionVo.class, HashSet.class, ArrayList.class, new String[0]));
            pageResult.getRecords().forEach(vo -> vo.setConclusionFileList(this.findConclusionFileById(vo.getId())));
        }
        return pageResult;
    }

    private List<ConclusionFileVo> findConclusionFileById(String conclusionId) {
        List<ConclusionFileEntity> fileEntities = this.conclusionFileRepository.findByConclusionId(conclusionId);
        if (CollectionUtils.isNotEmpty(fileEntities)) {
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList(fileEntities, ConclusionFileEntity.class, ConclusionFileVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return Lists.newArrayList();
    }
}

