package com.biz.crm.sfa.business.conclusion.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;
import java.util.Set;

/**
 * 工作总结请求DTO
 *
 * @author jerry7
 */
@Data
@ApiModel("工作总结请求DTO")
public class ConclusionDto extends TenantFlagOpDto {

  /**
   * 总结类别：日报/周报/月报/心得
   */
  @ApiModelProperty("总结类别：日报/周报/月报/心得")
  private String conclusionType;

  /**
   * 总结内容
   */
  @ApiModelProperty("总结内容")
  private String conclusionContent;

  /**
   * 工作计划
   */
  @ApiModelProperty("工作计划")
  private String workPlan;

  /**
   * 可见范围
   */
  @ApiModelProperty("可见范围")
  private String visibleScopeType;

  /**
   * 工作总结文件列表
   */
  @ApiModelProperty("工作总结文件列表")
  private List<ConclusionFileDto> conclusionFileList;

  /**
   * 指定可见人编码列表
   */
  @ApiModelProperty("指定可见人编码列表")
  private List<String> visibleScope;

  /**
   * @用户编码列表
   */
  @ApiModelProperty("@用户编码列表")
  private Set<String> callUserSet;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private String longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private String latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String conclusionAddress;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgName;

  /**
   * 上级职位编码
   */
  @ApiModelProperty("上级职位编码")
  private String parentPostCode;

  /**
   * 上级职位名称
   */
  @ApiModelProperty("上级职位名称")
  private String parentPostName;
}
