package com.biz.crm.sfa.business.conclusion.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 工作总结请求DTO
 *
 * @author jerry7
 */
@Data
@ApiModel("工作总结报表请求DTO")
public class ConclusionListDto extends TenantFlagOpDto {

  /**
   * 总结类别：日报/周报/月报/心得
   */
  @ApiModelProperty("总结类别：日报/周报/月报/心得")
  private String conclusionType;
  /**
   * 查询范围
   */
  @ApiModelProperty("查询范围")
  private String visibleScopeType;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgName;

  /**
   * 上级职位编码
   */
  @ApiModelProperty("上级职位编码")
  private String parentPostCode;

  /**
   * 上级职位名称
   */
  @ApiModelProperty("上级职位名称")
  private String parentPostName;

  /**
   * 查询提交人姓名
   */
  @ApiModelProperty("查询提交人姓名")
  private String userName;

  /**
   * 创建时间开始
   */
  @ApiModelProperty("创建时间开始")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 创建时间结束
   */
  @ApiModelProperty("创建时间结束")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String key;
}
