package com.biz.crm.sfa.business.conclusion.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

public enum ConclusionQueryScopeEnum {
  CONCLUSION_TYPE_ALL("ALL","ALL", "全部","1"),
  CONCLUSION_TYPE_SELF_SUPERIORS("SELF","SELF", "自己的","2"),
  CONCLUSION_TYPE_ORG_SUBORDINATE("SUBORDINATE","SUBORDINATE", "直属下级","3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ConclusionQueryScopeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ConclusionTypeEnum
   *
   */
  public static ConclusionQueryScopeEnum getByKey(String key) {
    return Arrays.stream(ConclusionQueryScopeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 ConclusionTypeEnum
   */
  public static ConclusionQueryScopeEnum getByDictCode(String dictCode) {
    return Arrays.stream(ConclusionQueryScopeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
