package com.biz.crm.sfa.business.conclusion.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

public enum ConclusionScopeEnum {
  CONCLUSION_TYPE_ALL("ALL","ALL", "全部","1"),
  CONCLUSION_TYPE_SELF_SUPERIORS("SELF_SUPERIORS","SELF_SUPERIORS", "自己及上级","2"),
  CONCLUSION_TYPE_ORG_SUBORDINATE("ORG_SUBORDINATE","ORG_SUBORDINATE", "所在组织及下级","3"),
  CONCLUSION_TYPE_COLLEAGUE("COLLEAGUE","COLLEAGUE", "自定义","4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ConclusionScopeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ConclusionTypeEnum
   *
   */
  public static ConclusionScopeEnum getByKey(String key) {
    return Arrays.stream(ConclusionScopeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 ConclusionTypeEnum
   */
  public static ConclusionScopeEnum getByDictCode(String dictCode) {
    return Arrays.stream(ConclusionScopeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
