package com.biz.crm.sfa.business.conclusion.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

public enum ConclusionTypeEnum {
  CONCLUSION_TYPE_DAILY("DAILY","DAILY", "日报","1"),
  CONCLUSION_TYPE_WEEKLY("WEEKLY","WEEKLY", "周报","2"),
  CONCLUSION_TYPE_MONTHLY("MONTHLY","MONTHLY", "月报","3"),
  CONCLUSION_TYPE_EXPERIENCE("EXPERIENCE","EXPERIENCE", "心得","4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ConclusionTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ConclusionTypeEnum
   *
   */
  public static ConclusionTypeEnum getByKey(String key) {
    return Arrays.stream(ConclusionTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 ConclusionTypeEnum
   */
  public static ConclusionTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(ConclusionTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
