package com.biz.crm.sfa.business.conclusion.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * 工作总结VO
 *
 * @author jerry7
 */
@Data
@ApiModel("工作总结返回VO")
public class ConclusionVo extends TenantFlagOpVo {

  /**
   * 总结类别：日报/周报/月报/心得
   */
  @ApiModelProperty("总结类别：日报/周报/月报/心得")
  private String conclusionType;

  /**
   * 总结内容
   */
  @ApiModelProperty("总结内容")
  private String conclusionContent;

  /**
   * 工作计划
   */
  @ApiModelProperty("工作计划")
  private String workPlan;

  /**
   * 可见范围
   */
  @ApiModelProperty("可见范围")
  private String visibleScopeType;

  /**
   * 工作总结文件列表
   */
  @ApiModelProperty("工作总结文件列表")
  private List<ConclusionFileVo> conclusionFileList;

  /**
   * 指定可见人编码列表
   */
  @ApiModelProperty("指定可见人编码列表")
  private List<String> visibleScope;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private String longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private String latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String conclusionAddress;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgName;
}
