package com.biz.crm.sfa.business.data.sample.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.local.service.DataSampleService;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSampleDto;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSamplePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 数据示例: DataSample: 数据示例配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/dataSample/dataSample")
@Api(tags = "数据示例: DataSample: 数据示例配置")
public class DataSampleController {

  @Autowired
  private DataSampleService dataSampleService;

  /**
   * 新增数据示例信息
   *
   * @param dto 参数dto
   * @return 新增数据示例数据
   */
  @ApiOperation(value = "新增数据示例")
  @PostMapping("")
  public Result<DataSampleEntity> create(@RequestBody DataSampleDto dto) {
    try {
      return Result.ok(this.dataSampleService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新数据示例信息
   *
   * @param dto 参数dto
   * @return 更新后数据示例数据
   */
  @ApiOperation(value = "更新数据示例信息")
  @PatchMapping("")
  public Result<DataSampleEntity> update(@RequestBody DataSampleDto dto) {
    try {
      return Result.ok(this.dataSampleService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据示例
   *
   * @param ids 数据示例id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.dataSampleService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用数据示例
   *
   * @param ids 数据示例id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.dataSampleService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用数据示例
   *
   * @param ids 数据示例id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.dataSampleService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 数据示例分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 数据示例分页数据
   */
  @ApiOperation(value = "数据示例分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<DataSampleEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "DataSampleCustomerPageDto", value = "分页Dto") DataSamplePageDto dto) {
    try {
      return Result.ok(this.dataSampleService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID获取数据示例详细信息
   *
   * @param id 数据示例ID
   * @return 数据示例信息
   */
  @ApiOperation(value = "通过ID获取数据示例详细信息")
  @GetMapping("/findById")
  public Result<DataSampleEntity> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.dataSampleService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
