package com.biz.crm.sfa.business.data.sample.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.data.sample.sdk.service.DataSampleVoService;
import com.biz.crm.sfa.business.data.sample.sdk.vo.DataSampleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 数据示例: DataSampleVo: 数据示例配置
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Slf4j
@RestController
@RequestMapping("/v1/dataSample/dataSample")
@Api(tags = "数据示例: DataSampleVo: 数据示例配置")
public class DataSampleVoController {

  @Autowired
  private DataSampleVoService dataSampleVoService;

  /**
   * 通过数据示例编码集合获取数据示例信息
   *
   * @param sampleCodes 数据示例编码集合
   * @return 数据示例信息
   */
  @ApiOperation(value = "通过数据示例编码集合获取数据示例信息")
  @GetMapping("/findBySampleCodes")
  public Result<List<DataSampleVo>> findBySampleCodes(@RequestParam("sampleCodes") Set<String> sampleCodes) {
    try {
      return Result.ok(this.dataSampleVoService.findBySampleCodes(sampleCodes));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
