package com.biz.crm.sfa.business.data.sample.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 数据示例实体类
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DataSampleEntity", description = "数据示例实体类")
@Entity
@TableName("sfa_data_sample")
@Table(name = "sfa_data_sample", indexes = {
    @Index(name = "sfa_data_sample_index1", columnList = "sample_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_data_sample", comment = "数据示例表")
public class DataSampleEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 1724805063676892251L;

  /**
   * 示例编码
   */
  @ApiModelProperty("示例编码")
  @Column(name = "sample_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '示例编码'")
  private String sampleCode;

  /**
   * 示例名称
   */
  @ApiModelProperty("示例名称")
  @Column(name = "sample_name", nullable = false, columnDefinition = "varchar(255) COMMENT '示例名称'")
  private String sampleName;

  /**
   * 示例类型
   */
  @ApiModelProperty("示例类型")
  @Column(name = "sample_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '示例类型'")
  private String sampleType;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;

  /**
   * 描述
   */
  @ApiModelProperty("描述")
  @Column(name = "description", columnDefinition = "varchar(255) COMMENT '描述'")
  private String description;

  /**
   * 示例照片
   */
  @ApiModelProperty("示例照片")
  @Transient
  @TableField(exist = false)
  private List<DataSamplePictureEntity> pictureList;
}
