package com.biz.crm.sfa.business.data.sample.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 数据示例照片实体类
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DataSamplePictureEntity", description = "数据示例照片实体类")
@Entity
@TableName("sfa_data_sample_picture")
@Table(name = "sfa_data_sample_picture", indexes = {
    @Index(name = "sfa_data_sample_picture_index1", columnList = "sample_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_data_sample_picture", comment = "数据示例照片表")
public class DataSamplePictureEntity extends FileEntity {

  private static final long serialVersionUID = -2869521613285834599L;

  /**
   * 示例ID
   */
  @ApiModelProperty("示例ID")
  @Column(name = "sample_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '示例ID'")
  private String sampleId;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  @Column(name = "sort_index", length = 4, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
  private Integer sortIndex;
}
