package com.biz.crm.sfa.business.data.sample.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSampleEntity;
import com.biz.crm.sfa.business.data.sample.local.model.DataSampleConditionModel;
import com.biz.crm.sfa.business.data.sample.sdk.dto.DataSamplePageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据示例表的mybatis-plus接口类 {@link DataSampleEntity}
 *
 * @author ning.zhang
 * @date 2022-07-27 16:15:08
 */
public interface DataSampleMapper extends BaseMapper<DataSampleEntity> {

  /**
   * 多条件查询数据示例列表
   *
   * @param model 条件model
   * @return 数据示例列表
   */
  List<DataSampleEntity> findByDataSampleConditionModel(@Param("model") DataSampleConditionModel model);

  /**
   * 数据示例分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<DataSampleEntity> 数据示例分页信息
   */
  Page<DataSampleEntity> findByConditions(Page<DataSampleEntity> page, @Param("dto") DataSamplePageDto dto);

}

