package com.biz.crm.sfa.business.data.sample.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * 数据示例多条件model
 *
 * @author ning.zhang
 * @date 2022/7/27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DataSampleConditionModel", description = "数据示例多条件model")
public class DataSampleConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  /**
   * 示例ID集合
   */
  @ApiModelProperty("示例ID集合")
  private Set<String> ids;

  /**
   * 示例编码集合
   */
  @ApiModelProperty("示例编码集合")
  private Set<String> sampleCodes;
}
