package com.biz.crm.sfa.business.data.sample.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.data.sample.local.entity.DataSamplePictureEntity;
import com.biz.crm.sfa.business.data.sample.local.mapper.DataSamplePictureMapper;
import org.springframework.stereotype.Component;

/**
 * 数据示例照片表的数据库访问类 {@link DataSamplePictureEntity}
 *
 * @author ning.zhang
 * @date 2022-07-27 16:15:10
 */
@Component
public class DataSamplePictureRepository extends ServiceImpl<DataSamplePictureMapper, DataSamplePictureEntity> {

  /**
   * 通过数据示例ID删除数据示例照片信息
   *
   * @param sampleId 数据示例ID
   */
  public void deleteBySampleId(String sampleId) {
    this.lambdaUpdate()
        .eq(DataSamplePictureEntity::getSampleId, sampleId)
        .remove();
  }
}
